
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   UTIL.H - Utility Function Prototypes
// 
//
//   DESCRIPTION
//
//   Prototypes for the utility functions.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\UTIL.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:50   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.4   Jul 09 1997 10:30:52   COLEJ
//    
//   
//      Rev 1.3   Feb 12 1997 16:04:44   COLEJ
//    
//   
//      Rev 1.2   Oct 31 1996 11:28:02   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:12:12   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:30   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

// function prototypes
void     GetBit      (tBOOL     *, tMSGBUF *, short, short);
void     GetBits     (tUSHORT   *, tMSGBUF *, short, short, short);
void     GetChar     (tCHAR     *, tMSGBUF *, short, short);
void     GetBool     (tBOOL     *, tMSGBUF *, short);
void     GetShort    (tSHORT    *, tMSGBUF *, short);
void     GetLong     (tLONG     *, tMSGBUF *, short);
void     GetUShort   (tUSHORT   *, tMSGBUF *, short);
void     GetULong    (tULONG    *, tMSGBUF *, short);
void     GetUTriple  (tUTRIPLE  *, tMSGBUF *, short);
void     GetTriple   (tTRIPLE   *, tMSGBUF *, short);
void     GetFloat    (tFLOAT    *, tMSGBUF *, short);
void     GetDouble   (tDOUBLE   *, tMSGBUF *, short);
void     PutBit      (tBOOL      , tMSGBUF *, short, short);
void     PutBits     (tUSHORT    , tMSGBUF *, short, short, short);
void     PutChar     (tCHAR      , tMSGBUF *, short, short);
void     PutBool     (tBOOL      , tMSGBUF *, short);
void     PutShort    (tSHORT     , tMSGBUF *, short);
void     PutLong     (tLONG      , tMSGBUF *, short);
void     PutUShort   (tUSHORT    , tMSGBUF *, short);
void     PutULong    (tULONG     , tMSGBUF *, short);
void     PutUTriple  (tUTRIPLE   , tMSGBUF *, short);
void     PutFloat    (tFLOAT     , tMSGBUF *, short);
void     PutDouble   (tDOUBLE    , tMSGBUF *, short);
short    CheckSum    (tMSGBUF   *, tSHORT);
void     ShowText    (char      *, short    , short);
void     ConvLatDegDM(double     , char *);
void     ConvLonDegDM(double     , char *);

// Datum definition
//
#define radius       (6378137.0)
#define eccentricity_squared (.006694380)
#define omega_sqrd  (1.0)
#define x_offset    (0.0)
#define y_offset    (0.0)
#define z_offset    (0.0)
#define DegToRad ( 3.141592654 / 180.0 )

typedef struct {
  double lat;
  double lon;
  double alt;
} tGeoPos; //, *tGeoPosPtr;

void     e2ndcm      (double lat , double lon, double cen[3][3]);
void     GeoidToENU  (tGeoPos GeoPos, tGeoPos RefGeoPos, double ENU[3]);
